# 📦 Image2WebP

**ローカル完結・PDF対応・非エンジニアでも使える画像一括変換ツール**

![license](https://img.shields.io/badge/license-MIT-blue.svg) ![python](https://img.shields.io/badge/python-3.8%2B-blue)

---

## 📌 概要

**Image2WebP** は、指定フォルダ内の画像（JPG / PNG / GIF / BMP）や PDF を軽量な WebP 形式に一括変換できる、**非エンジニアにもやさしいPythonツール**です。

- ✅ フォルダを選ぶだけでOK  
- ✅ PDFは全ページ自動で画像化してからWebPへ変換  
- ✅ 変換済みファイルは自動スキップ  
- ✅ オンライン不要、**ローカルで安全に完結**

---

## 🎯 背景と目的

- Webサイト更新のたびに画像変換が面倒  
- PDFバナー化も手間がかかる  
- Photoshopやオンライン変換は操作が煩雑 or セキュリティ懸念あり  

📌 こうした課題を **「誰でも扱える変換ツール」** として解決するのが本ツールの目的です。

---

## 🖥 対象ユーザー

- Webサイト運営・更新担当者  
- 業務資料作成・配布担当  
- 画像軽量化を求めるデザイナーや事務スタッフ  
- 非エンジニアでも使えるツールを探している人

---

## 🚀 機能一覧

| 機能 | 説明 |
|------|------|
| 📁 フォルダ選択 | GUIで入力フォルダ・出力フォルダを選択 |
| 🖼 画像変換 | JPG / PNG / BMP / GIF → WebP に変換 |
| 📄 PDF対応 | PDF → 各ページをJPEG変換 → WebP化 |
| 🔄 自動スキップ | 既に存在するWebPは上書きせずスキップ |
| ⚙ ローカル完結 | インターネット不要・安全に使用可能 |

---

## 🛠 使用技術

- Python 3.8+  
- [Pillow](https://python-pillow.org/)  
- [pypdfium2](https://pypi.org/project/pypdfium2/)  
- Tkinter（GUIフォルダ選択）

---

## 📦 インストール

```bash
python convert_to_webp.py

## ▶️ 使い方

### 1. 実行
```bash
pip install pillow pypdfium2

または、スクリプトをダブルクリック（Windows）
ターミナルが起動し、フォルダ選択ダイアログが2回表示されます。


### 2. 操作フロー
[起動]
  ↓
[入力フォルダ選択]
  ↓
[出力フォルダ選択]
  ↓
[画像・PDFを自動で処理]
  ↓
[WebPファイルが出力フォルダに保存]

✅ ログがターミナルにリアルタイムで表示されます。


### 📁 出力例
sample.jpg       → sample.webp
document.pdf     → document_p01.webp / document_p02.webp ...


### 📉 ランニングコスト
オンライン不要（完全ローカル動作）
外部サーバー費用なし
ライセンス費用なし（MITライセンス）


### ❓ よくある質問（FAQ）

Q. WebPにすると画質は落ちますか？
A. 保存時の品質を90に設定しているため、視認上はほとんど劣化が分かりません。

Q. 同じファイルを何度も変換してしまわない？
A. 出力先に同名WebPがあれば自動スキップします。

Q. PDFが複数ページでも大丈夫？
A. 各ページが個別に画像化され、連番付きで保存されます。


### 📝 開発者メモ

GUI不要環境（CLI）でも再利用しやすいよう、関数を分離
ファイル名は「元ファイル名＋拡張子」のみ（日付や連番をつけない仕様）


### 🧪 今後の展望（任意）
📎 ダウンロード・資料リンク

最新版ツール： テンテン工房 公式サイト

提案資料PDF： /docs/業務改善提案書_Image2Webp.pdf


### ✅ こんな方におすすめ！

✔ 画像変換の手間を減らしたい
✔ オンライン変換に不安がある
✔ ノンエンジニアでも使える軽量ツールを探している


### 🎉 ご利用ありがとうございます！

Image2WebP が皆さんの業務をちょっとでも快適にしますように。
Star & Fork 大歓迎です ⭐️











